#include <stdio.h>
#include <string.h>

#define SEGMENT 188
#define GROUP 256
#define CHUNK (SEGMENT*GROUP)
#define HEADER 0x10000
#define TBASE 0x4e2
#define SYNCID 0x47
#define META 32768
#define DATAFILE "%03d.dvr"
#define CBASE 0x176
#define FBASE 0x1a4
#define FSIZE 12

static int parse_file(char *fn,FILE *out)
{
	FILE *fp;
	size_t l;
	int total;
	int curr;
	int c;
	unsigned char *ptr;
	union
	{
		unsigned char bfr[CHUNK];
		unsigned char tab[HEADER];
	}u;


	fprintf(stderr,"Processing %s\n",fn);

	if((fp=fopen(fn,"rb"))==NULL)
	{
		fprintf(stderr,"Can't access file\n");
		return -1;
	}

	if((l=fread(u.tab,HEADER,1,fp))!=1)
	{
		fprintf(stderr,"Can't read file header\n");
		fclose(fp);
		return -1;
	}

	ptr=u.tab+TBASE;
	total=0;

	do
	{
		curr=ptr[1];
		curr<<=8;
		curr|=ptr[0];
		ptr+=8;
		if(total<curr)total=curr;
	}
	while(curr&&ptr<ptr+HEADER);

	for(curr=0;curr<total;curr++)
	{
		if((l=fread(u.bfr,CHUNK,1,fp))!=1)
		{
			fprintf(stderr,"File too short\n");
			fclose(fp);
			return -1;
		}

		for(ptr=u.bfr,c=0;c<GROUP;ptr+=SEGMENT,c++)if(*ptr!=SYNCID)
		{
			fprintf(stderr,"File stream error\n");
			fclose(fp);
			return -1;
		}

		if(fwrite(u.bfr,CHUNK,1,out)!=1)
		{
			fprintf(stderr,"Output write error\n");
			fclose(fp);
			return -1;
		}
	}

	fclose(fp);
	return 0;
}

static int parse_meta(char *fn,FILE *out)
{
	FILE *fp;
	size_t l;
	int total;
	int i;
	int curr;
	char *f;
	unsigned char *ptr;
	unsigned char bfr[META];
	char fnbuf[8192];


	strcpy(fnbuf,fn);
	if((f=strrchr(fnbuf,'/')))f++;
	else f=fnbuf;

	fprintf(stderr,"Processing %s\n",fn);

	if((fp=fopen(fn,"rb"))==NULL)
	{
		fprintf(stderr,"Can't access file\n");
		return -1;
	}

	if((l=fread(bfr,META,1,fp))!=1)
	{
		fprintf(stderr,"Can't read file header\n");
		fclose(fp);
		return -1;
	}

	fclose(fp);

	total=bfr[CBASE+1];
	total<<=8;
	total|=bfr[CBASE];

	for(ptr=bfr+FBASE,i=0;i<total;ptr+=FSIZE,i++)
	{
		curr=ptr[1];
		curr<<=8;
		curr|=ptr[0];
		sprintf(f,DATAFILE,curr);
		if(parse_file(fnbuf,out))return -1;
	}

	fprintf(stderr,"Done!\n");

	return 0;
}

int main(int argc,char *argv[])
{
	FILE *fp;

	if(argc!=3)
	{
		fprintf(stderr,"Usage: dvrmerge <pathname of info.dvr> "
			"<output file>\n");
		return 1;
	}

	if(!strcmp(argv[2],"-"))fp=stdout;
	else if((fp=fopen(argv[2],"wb"))==NULL)
	{
		fprintf(stderr,"Can't open output file\n");
		return 1;
	}

	if(parse_meta(argv[1],fp))
	{
		fclose(fp);
		return 1;
	}

	fclose(fp);
	return 0;
}
